/*
 * Decompiled with CFR 0.152.
 */
package component.button;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ButtonDemo
implements ActionListener {
    private JFrame frame = new JFrame("Button Demo");
    private JPanel panel = new JPanel();
    private JButton imageButton;
    private JButton textButton;
    private JButton imageTextButton;
    private String imagePath = "images/middle.gif";

    private void createAndDisplayGUI() {
        this.frame.setDefaultCloseOperation(3);
        this.textButton = new JButton("Click me to disable the next button");
        this.textButton.setVerticalTextPosition(0);
        this.textButton.setHorizontalTextPosition(0);
        this.textButton.setMnemonic(84);
        this.textButton.setDisplayedMnemonicIndex(9);
        this.imageButton = new JButton(this.getImage(this.imagePath));
        this.imageButton.setMnemonic(73);
        this.imageButton.setEnabled(false);
        this.imageTextButton = new JButton("Click me to disable the next button", this.getImage(this.imagePath));
        this.imageTextButton.setVerticalTextPosition(3);
        this.imageTextButton.setHorizontalTextPosition(0);
        this.imageTextButton.setMnemonic(66);
        this.imageTextButton.setDisplayedMnemonicIndex(16);
        this.imageTextButton.setEnabled(false);
        this.imageButton.addActionListener(this);
        this.textButton.addActionListener(this);
        this.imageTextButton.addActionListener(this);
        this.panel.add(this.textButton);
        this.panel.add(this.imageButton);
        this.panel.add(this.imageTextButton);
        this.frame.setContentPane(this.panel);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.textButton) {
            this.imageButton.setEnabled(true);
            this.textButton.setEnabled(false);
            this.imageTextButton.setEnabled(false);
        } else if (jButton == this.imageButton) {
            this.imageButton.setEnabled(false);
            this.textButton.setEnabled(false);
            this.imageTextButton.setEnabled(true);
        } else if (jButton == this.imageTextButton) {
            this.imageButton.setEnabled(false);
            this.textButton.setEnabled(true);
            this.imageTextButton.setEnabled(false);
        }
    }

    private ImageIcon getImage(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ButtonDemo buttonDemo = new ButtonDemo();
                buttonDemo.createAndDisplayGUI();
            }
        });
    }
}

